
/**
 * A canonical form (following well-established rules) of
 * the Person class.
 *
 * The canonical form of a Java class should provide
 * - a no-argument constructor (not implemented here - why?)
 * - methods for testing for object equality, equals and hashCode
 * - a method, toString, for String representation
 * - a method, clone, for cloning objects, if necessary making a deep copy
 * - an implementation of compareTo from interface Comparable defining the
 *   natural ordering for objects of this type (not implemented here)
 *
 * Fields should be private (or possibly protected)
 *
 * @author Anders Lindström
 * @version 1.00 2010/9/10
 */
public class CPerson implements Cloneable {

    private final String name;
    private int age;

    public CPerson(String name, int age) {
        this.name = name;
        this.age = age;
    }

    public String getName() {
        return name;
    }

    public int getAge() {
        return age;
    }

    public void setAge(int newAge) {
        age = newAge;
    }

    /**
     * Overriding equals, inherited from Object.
     */
    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }

        if (other instanceof CPerson) {
            CPerson otherPerson = (CPerson) other; // Downcast to type Person
            return this.age == otherPerson.age && this.name.equals(otherPerson.name);
        }

        return false;
    }

    /**
     * Overriding hashCode, inherited from Object A hash code is a sort of id
     * for an object of this type. This method is supported for the benefit of
     * hash tables.
     */
    @Override
    public int hashCode() {
        return age * 3 + name.hashCode() * 5;
    }

    /**
     * Overriding toString, inherited from Object.
     */
    @Override
    public String toString() {
        String info = name + ", age " + age;
        return info;
    }

    /**
     * Overriding clone, inherited from Object.
     */
    @Override
    public Object clone() {
        try {
            Person copy = (Person) super.clone();
            // Shallow copy (copy of references), is ok for Strings
            return copy;

        } catch (CloneNotSupportedException e) {
            // This should never happen...
            throw new Error();
        }
    }
}
